var WM7_STOPPED    = 1;
var WM7_PLAYING    = 3;
var WM7_PAUSED     = 2;
var WM7_WAITING    = 7;
var WM7_READY    = 10;

var objUtil = new UtilityObject(document);
var objWM7Ht = new HashTable();

var WM7_reqClip = null;
var WM7_intervalId = null;
function WM7_requestPlay(clipRef){
	clearInterval(WM7_intervalId);
	if (clipRef){
		WM7_reqClip = clipRef;
	}
	
	var readyState = WM7_getPlayState(WM7_reqClip);
	if (readyState == WM7_WAITING){
		setTimeout("WM7_requestPlay()",250);
	}
	else{
		WM7_intervalId = setInterval("_WM7_PLAY()",100);
	}
}

function _WM7_PLAY(){
	WM7_reqClip.controls.play();
	clearInterval(WM7_intervalId);
}

function WM7_stopAllClips(){
	var keyColl = objWM7Ht.getKeys();
	var clipRef = null;
	for (var i=0;i<keyColl.length;i++){
		clipRef = objWM7Ht.retrieve(keyColl[i]);
		WM7_stop(clipRef);
	}
}

function WM7_play(clipRef){
	if (typeof(clipRef) == "string") clipRef = objUtil.getObjectById(clipRef);
	
	objWM7Ht.insert(clipRef.id,clipRef);
	WM7_stopAllClips();
	WM7_requestPlay(clipRef);
}

function WM7_setSource(clipRef, url){
	if (typeof(clipRef) == "string") clipRef = objUtil.getObjectById(clipRef);
	clipRef.URL = url;
}

function WM7_getSource(clipRef){
	if (typeof(clipRef) == "string") clipRef = objUtil.getObjectById(clipRef);
	return WM7_cleanupURL(clipRef.URL);
}

function WM7_setSourcePlay(clipRef, url){
	if (typeof(clipRef) == "string") clipRef = objUtil.getObjectById(clipRef);
	clipRef.URL = url;
	WM7_play(clipRef);
}

function WM7_pause(clipRef)
{
	if (typeof(clipRef) == "string") clipRef = objUtil.getObjectById(clipRef);
	if (clipRef.controls.isAvailable('Pause')){
		clipRef.controls.pause();
	}
}

function WM7_stop(clipRef){
	if (typeof(clipRef) == "string") clipRef = objUtil.getObjectById(clipRef);
	if (clipRef.controls.isAvailable('Stop')){
		clipRef.controls.stop();
	}
}

function WM7_setPosition(clipRef, pos){
	if (typeof(clipRef) == "string") clipRef = objUtil.getObjectById(clipRef);
	clipRef.controls.currentPosition = parseInt(pos+"")/1000;
}

function WM7_getLength(clipRef){
	if (typeof(clipRef) == "string") clipRef = objUtil.getObjectById(clipRef);
	return clipRef.currentMedia.duration*1000;
}

function WM7_getPlayState(clipRef){
	if (typeof(clipRef) == "string") clipRef = objUtil.getObjectById(clipRef);
	retVal = clipRef.playState;
	if (retVal != WM7_STOPPED && retVal != WM7_PLAYING && retVal != WM7_PAUSED && retVal != WM7_READY){
		retVal = WM7_WAITING;
	}
	return retVal;
}

function WM7_getPosition(clipRef){
	if (typeof(clipRef) == "string") clipRef = objUtil.getObjectById(clipRef);
	return clipRef.controls.currentPosition*1000;
}

function WM7_getClipRef(clipRef)
{
	if (typeof(clipRef) == "string") clipRef = objUtil.getObjectById(clipRef);
	return clipRef;
}

function WM7_cleanupURL(url){
	url = url + "";
	for (var i=0;i<url.length;i++)
	{
		if (url.charCodeAt(i) < 32 || url.charCodeAt(i) > 126){
			//alert("Illegal Character Found at position " + i);
			url = url.slice(0,i) + url.slice(i+1,url.length);
		} 
		else if (url.charAt(i) == "\\"){
			url = url.slice(0,i) + "/" + url.slice(i+1,url.length);
		}
	}
	return url;
}

// utility.js
// Scott Brause
// 2003-11-24

var SB_UTIL_2003_11_05_InIe = (navigator.appName.toLowerCase().indexOf("internet explorer") > -1);
var SB_UTIL_2003_11_05_InNetscape = (navigator.appName.toLowerCase().indexOf("netscape") > -1);
var SB_UTIL_2003_11_05_DomSupported = (document.documentElement?(true):(false));

function UtilityObject(doc){
	if (!doc){
		doc = document;
	}
	this.doc = doc;
	
	return this;
}
UtilityObject.prototype.getObjectById = SB_UTIL_2003_11_05_GetObjectById;

// Object SB_UTIL_2003_11_05_GetObjectById(String objectId, Document doc)
//
// Function used to locate an object by its id or name.
function SB_UTIL_2003_11_05_GetObjectById(objectId, doc){
	// Initialize retVal to null
	var retVal = null;
	
	// Resolve which document is being searched
	if (!doc){
		doc = this.doc;
	}
	
	// If running under IE
	if (SB_UTIL_2003_11_05_InIe){
		// If this version of IE supports DOM then
		// use getElementById(), else use the all[] array.
		if (SB_UTIL_2003_11_05_DomSupported){
			retVal = doc.getElementById(objectId);
		}
		else{
			retVal = doc.all['objectId'];
		}
	}
	// If running under Netscape
	else if (SB_UTIL_2003_11_05_InNetscape){
		// If DOM is supported, then try it first
		// by calling getElementById().
		if (SB_UTIL_2003_11_05_DomSupported){
			retVal = doc.getElementById(objectId);
		}
		
		// If retVal is still null
		if (!retVal){
			// We are either in Netscape 4.5 and lower, or
			// we are in a higher version that supports DOM,
			// but can't find the specified object by its id,
			// so we must now use the document arrays to
			// search for the object.
			
			if (doc.layers){
				retVal = doc.layers[objectId];
			}
			
			if (!retVal){
				retVal = doc.images[objectId];
				if (!retVal){
					retVal = doc.forms[objectId];
					if (!retVal){
						retVal = doc.anchors[objectId];
						if (!retVal){
							retVal = doc.links[objectId];
							if (!retVal){
								retVal = doc.embeds[objectId];
								if (!retVal){
									retVal = doc.plugins[objectId];
									if (!retVal){
										retVal = doc.applets[objectId];
									}
								}
							}
						}
					}
				}
			}
			
			// If the object is still not found, then
			// we will need to search recursively through
			// all of the layers (if the layers array is
			// supported), until it is found, or we run
			// out of layers to search through.
			//alert("1: " + retVal);
			if (!retVal && doc.layers){
				// Recurse down through layers
				for (var i=0;i<doc.layers.length;i++){
					retVal = this.getObjectById(objectId,doc.layers[i].document);
					if (retVal){
						return retVal;
					}
				}
			}
		}
	}
	else{
		// unsupported browser
		retVal = null;
	}
	
	return retVal;
}
